
function logpdf = hyper_add_seiso_logpdf(x, pos, theta, K_obs, f, mean_f, m_prior, v_prior, SD2, core, noise_matrix)

theta(pos) = x;
K_add = exp(theta(1)) * SD2 .* exp(-0.5 * core / exp(theta(2)));
K = K_obs + K_add + noise_matrix;
if isnan(sum(sum(K)))
  disp('!')
end
if min(eig(K)) <= 0
  logpdf = -Inf;
  return
end
f_c = f - mean_f;

logpdf = -(x - m_prior)^2 / v_prior - sum(log(eig(K))) - trace(K \ (f_c * f_c'));
