% run_intervention:
%
% Simulate data generation under an interventional regime
%
% Input:
%
% - x: point of evaluation
% - model: model as given by 'generate_problem_GP'
%
% Output:
%
% - y: generated outcome

function [y, mean_y] = run_intervention(x, model, y_center, y_scale)

if model.poly == false
  % This requires pre-computed outputs for every possible x
  x_idx = find(model.X_space == x);
  if isempty(x_idx), error('Invalid generative model'); end
  mean_y = model.f_space(x_idx);
  y = mean_y + randn() * sqrt(model.var_error);
  return
end

if nargin < 4
  y_center = 0;
  y_scale = 1;
end

x_c = (x - model.center) / model.scale;
mean_y = x_c.^(length(model.coeff) - 1:-1:0) * model.coeff + model.intercept;
y = mean_y + randn() * sqrt(model.y_var + model.exo_var);

y = (y - y_center) / y_scale;
mean_y = (mean_y - y_center) / y_scale;
