#ifndef HEADER_OPT
#define HEADER_OPT

#include <vector>
#include <random>
#include <eigen3/Eigen/Core>

class OptimismHandler {
  public:
  void optimistic(std::vector<Eigen::VectorXf> hat_nu, std::vector<Eigen::MatrixXf> Gs, float b, Eigen::MatrixXf &tilde_nu, Eigen::MatrixXf &Mt, float &best);

  private:

  Eigen::VectorXf random_sphere(int D);
  std::default_random_engine gen;

};


#endif
