#ifndef HEADER_UMOSS
#define HEADER_UMOSS

#include "bandit_alg.h"
#include "arm.h"

#include <queue>
#include <cstdint>
#include <string>
#include <vector>


class UMOSS : public BanditAlgorithm {
  public:
  void give_reward(double r);
  void setup(uint64_t n, int K);
  int get_arm(); 
  std::string id();

  UMOSS(double a, std::vector<double> b) : alpha(a), bias(b) {
    
  }

  private:
  uint64_t n;
  int K;
  double alpha;
  std::vector<double> bias;
  std::priority_queue<Arm> arms;
};

#endif
