/******************************************************
* This is designed to read the binary data files and 
* output a plain text table suitable for plotting.
******************************************************/
#include <iostream>
#include <vector>
#include <sstream>
#include <fstream>
#include <set>
#include <map>
#include <cstdint>

#include "data.h"
#include "log.h"

using namespace std;




int main(int argc, char* argv[]) {
  if (argc != 2) {
    cout << "bad arguments\n";
    return 0;
  }
  map<double,map<int,Data> > table;
  string line;
  ifstream in(argv[1], ios::in);
  while (!in.eof()) {
    LogEntry e;  
    in.read((char*)&e, sizeof(LogEntry));
    auto iter1 = table.find(e.x);
    if (iter1 == table.end()) {
      table[e.x] = {{e.id, Data(e.y)}};
    }else {
      auto iter2 = iter1->second.find(e.id);
      if (iter2 == iter1->second.end()) {
        iter1->second[e.id] = Data(e.y);
      }else {
        iter2->second << e.y;
      }
    }
  }
  cout << "\%x ";
  for (auto &alg : table.begin()->second) {
    cout << alg.first << " ";
  }
  cout << "\n";
  for (auto &x : table) {
    cout << x.first << " ";
    for (auto &alg : x.second) {
      cout << alg.second.mean() << " ";
    }
    for (auto &alg : x.second) {
      cout << 2.0 * alg.second.standard_error() << " ";
    }
    for (auto &alg : x.second) {
      cout << alg.second.size() << " ";
    }
    for (auto &alg : x.second) {
      cout << alg.second.quantile(0.9) << " ";
    }
    cout << "\n";
  }
}










