#ifndef HEADER_MOSS
#define HEADER_MOSS

#include "bandit_alg.h"
#include "arm.h"

#include <queue>
#include <cstdint>
#include <string>


class MOSS : public BanditAlgorithm {
  public:
  void give_reward(double r);
  void setup(uint64_t n, int K);
  int get_arm(); 
  std::string id();

  MOSS(double a) : alpha(a) {
  }

  private:
  uint64_t n;
  int K;
  double alpha;
  std::priority_queue<Arm> arms;
};

#endif
