#include "moss.h"

#include <cfloat>
#include <cmath>
#include <algorithm>
#include <string>

using namespace std;


void MOSS::setup(uint64_t n, int K) {
  this->n = n;
  this->K = K;

  /* initialise the arms data structure */
  while (arms.size() > 0) {
    arms.pop();
  }
  for (int i = 0;i != K;++i) {
    arms.push(Arm(i, DBL_MAX));
  }
}
  

void MOSS::give_reward(double r) {
  Arm a = arms.top();
  arms.pop();

  a.T+=1;
  a.reward+=r;
  a.idx = a.reward / a.T + sqrt(alpha / a.T * log(max(1.0, n / (double)(K * a.T))));
  arms.push(a);
}

int MOSS::get_arm() {
  /* return the arm with the highest index */
  return arms.top().i;
}



