#ifndef HEADER_G_BANDIT
#define HEADER_G_BANDIT


#include <cstdint>
#include <vector>
#include <random>
#include <functional>
#include <string>

#include "bandit_alg.h"


class GaussianBandit : public BanditProblem {
  public:
  
  GaussianBandit(int n, std::vector<double> means, std::default_random_engine &g) : gen(g) {
    this->n = n;
    this->K = means.size();
    this->means = means;
    setup();
  }


  double sample(int i) {
    std::normal_distribution<double> dist(means[i], 1.0);
    return dist(gen);
  }

  double mean(int i) {
    return means[i];
  }


  private:
  std::default_random_engine &gen;

  std::vector<double> means;
};


#endif
