#include "bandit_alg.h"

#include <cfloat>
#include <iostream>

using namespace std;

void BanditProblem::setup() {
  double max_mu = -DBL_MAX;
  for (int i = 0;i != K;++i) {
    if (mean(i) > max_mu) {
      max_mu = mean(i);
    }
  }
  for (int i = 0;i != K;++i) {
    gaps.push_back(max_mu - mean(i));
  }
}


double BanditProblem::gap(int i) {
  return gaps[i];
}


void BanditAlgorithm::setup(uint64_t n, int K) {
  this->n = n;
  this->K = K;
}
