function result = Kmu(C,D,P,d,delta)


%% calculate the right integration limits to avoid error when the gaussian is too peaked.
binf =d-sqrt(12*delta)/2;
bsup =d+sqrt(12*delta)/2;


result1 = Int(P+1,D,C,binf,bsup);
result2 = Int(P,D,C,binf,bsup);
result = result1./result2;


%% for small variances, we take the asymptotic expressions
lim =1e-15;
result(C<lim) = D(C<lim) + P./D(C<lim).*C(C<lim) -P*(P-1)./D(C<lim).^3.*C(C<lim).^2;
result(C<lim & D<binf) = binf - C(C<lim & D<binf)./(D(C<lim & D<binf)-binf) ;
result(C<lim & D>bsup) = bsup - C(C<lim & D>bsup)./(D(C<lim & D>bsup)-bsup) ;


end
