
# First we load the R source code and the C 
# implementaiton of the function that computes 
# the expected moments using quadrature

source("horseShoeEP_4Q.R")
dyn.load("refinePriorTermsHSFast.so")

set.seed(0)

# We run a simple iteration of the toy problem described in the paper

W <- X <- Y <- list()

for (i in 1 : (64)) {

	N <- 64
	d <- 128
	k <- sample(1 : 16)[ 1 ]

	w <- rep(0, d)
	w[ (1 : 8) + (k - 1) * 8 ] <- sign(rnorm(8)) * runif(8)

	xtask <- matrix(rnorm(d * N), N, d)
	ytask <- xtask %*% w + rnorm(N, sd = sqrt(.5))

	X[[ i ]] <- xtask
	Y[[ i ]] <- ytask
	W[[ i ]] <- w
}

s <- 1 : 64

data <- list(X = X[ s ], Y = Y[ s ], W = W[ s ])

# The data has been generated. Now we train the model and test the reconstruction error.

# First we train a model that considers single task learning. This model is used to find
# the hyper-parameters for the model that learns the dependencies in the feature
# selection process, which is trained later.

# This vector will store the errors of the model for single task learning

err <- rep(0, length(data$W))

# These vectors will store the levels of sparsity found for single task learning

cu <- rep(0, 64)
cv <- rep(0, 64)

for (i in 1 : length(data$W)) {


	# No pseudo-vectors for the covariance matrix

	Z <- matrix(0, nrow(data$X[[ i ]]), ncol(data$X[[ i ]]))

	retST <- horseShoeEPMultiTask(X = data$X[ i ], Y = data$Y[ i ], sigma2 = log(.5), Z = Z, cu = -3, cv = 3, learnDictionary = FALSE, 
		Xinitial = NULL, relationYtoX = NULL, sharedNoiseParam = FALSE, sharedSparsityLevel = FALSE, 
		multiCore = FALSE, flagsToLearn = c(1, 0, 0, 0))

	err[ i ] <- sqrt(sum((data$W[[ i ]] - retST$means)^2)) / sqrt(sum(data$W[[ i ]]^2))
	cu[ i ] <- retST$cuTask[[ 1 ]]
	cv[ i ] <- retST$cvTask[[ 1 ]]

	cat("Error on task", i, "for single task learning:", err[ i ], "\n")
}

cat("Mean error single task learning (HS_ST):", mean(err), "\n")

write.table(err, file = "errors_HS_ST.txt", row.names = F, col.names = F)

# This vector will store the errors of the model for multi task learning that learns dependencies in the
# feature selection process.

errHSdep <- rep(0, length(data$W))

# This trains the multi-task model HSdep. It uses 4 cores to speed-up the trainig process. The number of
# cores to use can be modified in the R code. It only optimizes the Pseudo-vectors that will specify the
# dependencies in the feature selection process

retHSdep <- horseShoeEPMultiTask(X = data$X, Y = data$Y, sigma2 = log(.5), cu = cu, cv = cv, learnDictionary = FALSE, 
	Xinitial = NULL, relationYtoX = NULL, sharedNoiseParam = FALSE, sharedSparsityLevel = FALSE, 
	multiCore = TRUE, flagsToLearn = c(0, 0, 1, 0))

for (i in 1 : length(data$W)) {

	errHSdep[ i ] <- sqrt(sum((data$W[[ i ]] - retHSdep$means[, i])^2)) / sqrt(sum(data$W[[ i ]]^2))
	cat("Error on task", i, "for HS_dep:", err[ i ], "\n")
}

cat("Mean error for HS_dep:", mean(errHSdep), "\n")

write.table(errHSdep, file = "errors_HS_dep.txt", row.names = F, col.names = F)


