function [err_opt, err_mu, err_d, err_con] = op_lstd(n, k, metric, k_mu, M, M_sample, k_clusters, max_iter)

% generate random MDP
gamma = 0.99;

parfor t=1:M,
  % randomnly sample MDP and sampling distribution
  rand('state',t);
  randn('state',t);
  
  if (metric)
    [X,P,R,Phi] = spatial_mdp(n, 2, k, gamma, 0.4);
  else
    P = dir_sample(n,0.4*ones(n,1))';
    R = randn(n,1);
    Phi = [randn(n,k-1) ones(n,1)];
  end
  % compute stationary distribution
  [U,S] = eig(P');
  [s,i] = sort(abs(diag(S)), 'descend');
  d_mu = U(:,i(1)) ./ sum(U(:,i(1)));
  
  d_rand = dir_sample(1,ones(n,1)+k_mu*d_mu);
  V = (eye(n) - gamma*P) \ R;
  V_d_opt = Phi*((Phi' * (repmat(d_rand,1,k) .* Phi)) \ (Phi' * (d_rand .* V)));
  
  % optimize sampling distribution
  if (M_sample == 0)
    % optimize over exact state distribution
    d_con = optimize_dist2(d_rand, Phi, P*Phi, max_iter, 1:n);
    
    V_mu_td = Phi * lstd(Phi, P*Phi, R, d_mu, gamma);
    V_d_td = Phi * lstd(Phi, P*Phi, R, d_rand, gamma);
    V_con_td = Phi * lstd(Phi, P*Phi, R, d_con, gamma);
  elseif (M_sample > 0)
    % optimize over sampled states
    % randomly sample M_sample states from d_mu
    S = mnrnd(1,d_mu,M_sample); [i,j] = find(S');
    Phi_ = Phi(i,:);
    R_ = R(i);
    Sn = mnrnd(1, P(i,:)); [i,j] = find(Sn');
    Phin_ = Phi(i,:);
    V_mu_td = Phi * lstd(Phi_, Phin_, R_, ones(M_sample,1)/M_sample, gamma);
    
    % randomly sample M_sample states
    S = mnrnd(1,d_rand,M_sample); [i,j] = find(S');
    Phi_ = Phi(i,:);
    R_ = R(i);
    Sn = mnrnd(1, P(i,:)); [i,j] = find(Sn');
    Phin_ = Phi(i,:);
    V_d_td = Phi * lstd(Phi_, Phin_, R_, ones(M_sample,1)/M_sample, gamma);
    
    
    % cluster the features and optimize over distribution
    idx = fast_kmeans(Phi_', k_clusters);
    d_con = optimize_dist2(ones(M_sample,1)/M_sample, Phi_, Phin_, max_iter, idx);
    V_con_td = Phi * lstd(Phi_, Phin_, R_, d_con, gamma);
  end
  
  % compute errors
  Z = sqrt(V'*(d_rand.*V));
  err_opt(t) = sqrt((V_d_opt - V)'*(d_rand.*(V_d_opt - V))) / Z;
  err_mu(t) = sqrt((V_mu_td - V)'*(d_rand.*(V_mu_td - V))) / Z;
  err_d(t) = sqrt((V_d_td - V)'*(d_rand.*(V_d_td - V))) / Z;
  err_con(t) = sqrt((V_con_td - V)'*(d_rand.*(V_con_td - V))) / Z;
end

% simple batch lstd solution
function w = lstd(Phi, Phin, R, d, gamma)
w = (Phi'*(repmat(d,1,size(Phi,2)).*(Phi - gamma*Phin))) \ (Phi'*(d.*R));
