%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% get_pairwise_entropy_sets:
%
% Cache the calculation of conditional entropies scores for all possible 
% singleton parents (plus the empty set)
%
% Input:
%
% - entropy_order: order to be followed, which defines which singleton
%                  parent sets to include
% - cond_entropy: all corresponding conditional entropies, where
%                 cond_entropy(i, j) is the conditional entropy of Y_i 
%                 given Y_j (except cond_entropy(i, i), which is the
%                 marginal entropy of Y_i)
%
% Output:
%
% - entropy_sets: cell structure listing relevant entropy set information,
%                 with "parents" and a "values" fields matching at the
%                 corresponding positions
%
% Created by: Ricardo Silva, London, 22/05/2011
% University College London
%
% Current version: 22/05/2011

function entropy_sets = get_pairwise_entropy_sets(entropy_order, cond_entropy)

num_y = length(entropy_order);
entropy_sets = cell(num_y, 1);

for y_pos = 1:num_y
  y = entropy_order(y_pos);
  entropy_sets{y}.parents = entropy_order(1:y_pos - 1);
  entropy_sets{y}.values = [cond_entropy(y, entropy_sets{y}.parents)'; ...
                            cond_entropy(y, y)];  
end
