%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% eval_probit_predict_mcmc:
%
% Calculate how predictive a subset of variables is with respect to another
% subset of variables.
%
% Input:
%
% - outcomes: indices of variables we will predict
% - Y_test: the test data
% - X_hat_train: already fitted training covariates
% - X_hat_test:  already fitted test covariates
%
% Output:
%
% - score: the entropy
%
% Created by: Ricardo Silva, London, 05/05/2011
% University College London
% Current version: 05/05/2011

function [scores scores_fit] = eval_probit_predict_mcmc(outcomes, Y_test, X_samples, L)

N = size(Y_test, 1);
num_y = length(outcomes);
num_x = size(X_samples, 2);
num_mcmc = size(X_samples, 3);
Y_probhat = zeros(num_y, N);

for m = 1:num_mcmc
  means = L(outcomes, 1:num_x) * X_samples(:, :, m)' + repmat(L(outcomes, end), 1, N);
  Y_probhat = Y_probhat + normcdf(means);
end

Y_probhat = Y_probhat / num_mcmc;

scores = zeros(num_y, 1);
scores_fit = zeros(num_y, 1);
y_count = 1;

for y = outcomes
  Y = Y_test(:, y);
  Y(Y == -1) = 0;
  yfit_prob = Y_probhat(y_count, :)';
  yfit = yfit_prob > 0.5;
  scores(y_count) = mean(yfit == Y);
  scores_fit(y_count) = (sum(log(yfit_prob(Y == 1))) + sum(log(1 - yfit_prob(Y == 0)))) / length(Y);
  y_count = y_count + 1;
end

