%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% get_moments:
%
% Get mean and covariance matrix of a probit model.
%
% Input:
%
% - L, S: parameters of the underlying probit SEM
%
% Output:
%
% - m, C: mean and covariance matrix.
%
% Created by: Ricardo Silva, London, 21/05/2011
% University College London
% Current version: 21/05/2011


function [m C] = get_moments(L, S)

[num_y num_x] = size(L); num_x = num_x - 1;

m_probit = L(:, end);
cov_probit = L(:, 1:num_x) * S * L(:, 1:num_x)' + eye(num_y);

m = zeros(num_y, 1);

for y = 1:num_y
  m(y) = normcdf(m_probit(y) / sqrt(cov_probit(y, y)));
end

C = zeros(num_y);

for y1 = 1:num_y
   for y2 = y1:num_y
     a = -m_probit([y1 y2]); b = [Inf; Inf];  
     C(y1, y2) = qscmvnv(5000, cov_probit([y1 y2], [y1 y2]), a, eye(2), b);
     C(y2, y1) = C(y1, y2);
   end
end

C = C - m * m';
