%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% get_cond_entropy:
%
% Get conditional entropy of first variable in a table given a subset of 
% the others.
%
% Input:
%
% - y_sel: binary vector indicating which marginal of table to be used
%          (ignore first entry)
% - table: the corresponding contingency table
%
% Output:
%
% - value: the conditional entropy
%
% Created by: Ricardo Silva, London, 05/05/2011
% University College London
% Current version: 05/05/2011

function value = get_cond_entropy(y_subset_bin, table)

y_subset_bin(1) = 1; % Enforce this
set_size = length(y_subset_bin);

% Preliminaries          

y_subset_nbin = 1 - y_subset_bin;
subset_size   = sum(y_subset_bin);    
num_comb_sel  = 2^subset_size;

nonsel_set = find(y_subset_bin == 0);
num_comb_nonsel = 2^length(nonsel_set);

% Marginalize the excluded variables

marginals = zeros(num_comb_sel, 1);
subset_value = zeros(subset_size, 1);
for j = 1:num_comb_sel      
  nonsel_value = zeros(length(nonsel_set), 1);
  for k = 1:num_comb_nonsel
    full_value = zeros(1, set_size);
    full_value(y_subset_bin == 1)  = subset_value;
    full_value(y_subset_nbin == 1) = nonsel_value;
    marginals(j) = marginals(j) + table(parent_entry(full_value));
    nonsel_value = advance_bits(nonsel_value);
  end
  subset_value = advance_bits(subset_value);
end

% Calculate conditional entropy: iterate through all values

value = 0;
num_p_sel = 2^(subset_size - 1);
p_value = zeros(1, subset_size - 1);
for j = 1:num_p_sel
   idx = zeros(1, subset_size);
   idx(1) = 1; idx(2:end) = p_value;
   marg_value_1 = marginals(parent_entry(idx));  
   idx(1) = 0;
   marg_value_2 = marginals(parent_entry(idx));  
   sum_marg = marg_value_1 + marg_value_2;
   value = value ...
        - marg_value_1 * (log(marg_value_1) - log(sum_marg)) ...
        - marg_value_2 * (log(marg_value_2) - log(sum_marg));
   p_value = advance_bits(p_value);
end
