
% Based on: http://mahieddine.ichir.free.fr/Matlab/matlab.html

function z = FastTruncatedGaussRND(x0, a, b)
% TruncatedGaussPDF Random numbers from the Probability
%  Density Function given by:
%
%    P = K * exp(-0.5 * (x - x0)^2) I_[a,b[
% with
%     a <= b, x0 in R
%
% and 'a' and 'b' are vectors of the same size

n = length(a);

u  = rand(n, 1);
y1 = sqrt(0.5) * (a - x0);
y2 = sqrt(0.5) * (b - x0);
z  = (erfinv(u .* erf(y2) + (1 - u) .* erf(y1))) / sqrt(0.5) + x0;
