%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% optimize_probitsem_entropy_gaussian:
%
% Choose a subset of variables using a Gaussian approximation for the 
% entropy.
%
% Input:
%
% - L, S: parameters of probit model
% - sel_K_start: initialization vector
%
% Output:
%
% - sel_K: the selection of K variables
%
% Created by: Ricardo Silva, London, 21/05/2011
% University College London
%
% Current version: 21/05/2011

function sel_K = optimize_probitsem_entropy_gaussian(L, S, sel_K_start)

[num_y num_x] = size(L); num_x = num_x - 1;
[~, impl_cov] = get_moments(L, S);

% Calculate univariate weights

W = zeros(num_y, 1);
M = 100000;

x = chol(S)' * randn(num_x, M);

for y = 1:num_y
   m = L(y, 1:num_x) * x + L(y, end);
   py0 = normcdf(-m); py1 = 1 - py0; 
   log_py1 = log(py1); log_py1(py1 == 0) = 0;
   log_py0 = log(py0); log_py0(py0 == 0) = 0;
   W(y) = mean(py1 .* log_py1 + py0 .* log_py0);
end

clear('x');

% Optimize choice of variables

sel_K = sel_K_start;
z = zeros(1, num_y);
z(sel_K) = 1;
not_sel_K = find(z == 0);

best_score = sum(W(sel_K)) + log(det(impl_cov(sel_K, sel_K)));
fprintf('Initial score = %f\n', best_score);

iter = 1;

fprintf('Initial score = %f: \n', best_score);

while true
  fprintf('Iteration [%d], ', iter);

  changed = false;
  for y1 = sel_K
    for y2 = not_sel_K     
     z(y1) = 0; z(y2) = 1;
     score = sum(W(z == 1)) + log(det(impl_cov(z == 1, z == 1)));
     if score > best_score
       best_score = score;
       best_pair = [y1 y2];
       changed = true;
     end
     z(y1) = 1; z(y2) = 0;
    end
  end
  
  if ~changed
    break
  end
  
  z(best_pair) = 1 - z(best_pair);
  sel_K = find(z == 1);
  not_sel_K = find(z == 0);

  fprintf('Gaussian current solution: score = %f\n', best_score);
  iter = iter + 1;   
end
fprintf('Score found: %f\n', best_score);

