%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% get_entropy_score:
%
% Calculate a bound on the entropy of a marginal distribution using a set
% of pre-processed entropy numbers.
%
% Input:
%
% - z: the total number of variables to keep
% - entropy_sets: data structure caching conditinal entropies for all
%                 subsets of "parents" of each variable
%
% Output:
%
% - score: the entropy bound
%
% Created by: Ricardo Silva, London, 05/05/2011
% University College London
% Current version: 05/05/2011

function score = get_entropy_score(z, entropy_sets)

num_y = length(z);
score = 0;

for y = 1:num_y
  if z(y) == 0
    continue
  end
  p = parent_entry(z(entropy_sets{y}.parents));
  score = score + entropy_sets{y}.value(p);
end
