%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% batch_test_sem:
%
% Evaluate and contrast several selection methods using a set of simulated
% models. It is assumed that models were generated according to the script
% 'batch_generate_sem' - a total of 80 files. Those files are assumed to
% exist in the corresponding directories. Please see 'batch_generate_sem'
% for further details. 160 experiments will be run, 2 for each data file.
%
% The 'naive' method is based on optimizing the reliability index
% heuristic. 'bound1' is the bounded neighborhood method, while 'bound2'
% is the tree-based method. The 'rand' method is based on just choosing a
% selection uniformly at random. 'gauss' is the Gaussian entropy greedy
% optimization method.
%
% Look at 'simulate_sem' for the required parameters that are assumed to
% exist. 
%
% DON'T FORGET TO CHANGE THE OUTPUT DIRECTORY WHERE LOG FILES ARE
% GENERATED. PLEASE CHANGE THE VALUE OF VARIABLE 'OUT_DIR'.
%
% PLEASE NOTICE THAT THIS IMPLEMENTATION IS NOT MEANT TO BE FINE TUNED.
% RUNNING ALL 160 SYNTHETIC EXPERIMENTS SHOULD TAKE DAYS IN A REGULAR
% DESKTOP.
%
% Created by: Ricardo Silva, London, 21/04/2011
% University College London
%
% Current version: 24/09/2011

% General initialization %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

load('nips_seed.mat')

OUT_DIR = 'C:\temp\experiments';
OUT_DIR_SYNTH = strcat(OUT_DIR, '\synth');
OUT_DIR_SYNTH1 = strcat(OUT_DIR_SYNTH, '\high_signal');
OUT_DIR_SYNTH2 = strcat(OUT_DIR_SYNTH, '\low_signal');
if ~exist(OUT_DIR, 'dir')
  mkdir(OUT_DIR)
end
if ~exist(OUT_DIR_SYNTH, 'dir')
  mkdir(OUT_DIR_SYNTH)
end
if ~exist(OUT_DIR_SYNTH1, 'dir')
  mkdir(OUT_DIR_SYNTH1)
end
if ~exist(OUT_DIR_SYNTH2, 'dir')
  mkdir(OUT_DIR_SYNTH2)
end

num_y = 40; num_x = 10;
num_trials = 20;
high_K = 32; low_K = 20;

y_keep = 1:num_y;
num_mcmc = 5100; burn_in = 100;
K_width = 9;

% Run comparisons %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for level = 1:2
  if level == 1
    TARGET_DIR = OUT_DIR_SYNTH1;
    DATA_DIR = 'data\synth\high_signal';
  else
    TARGET_DIR = OUT_DIR_SYNTH2;
    DATA_DIR = 'data\synth\low_signal';
  end
  for s = 1:4 % Style
    for nt = 1:num_trials    
      if s == 1
        STYLE = 'WC'; %Weak coupling, high sparsity
        K = low_K;
      elseif s == 2
        STYLE = 'WC'; %Weak coupling, low sparsity
        K = high_K;
      elseif s == 3
        STYLE = 'SC'; %Strong coupling, high sparsity
        K = low_K;
      else
        STYLE = 'SC'; %Strong coupling, low sparsity
        K = high_K;
      end    
      OUT_FILE_NAME = strcat(TARGET_DIR, '\SYNTH_', int2str(num_y), '_', ...
                             int2str(num_x), '_', int2str(K), '_', STYLE, ...
                             '_', int2str(nt), '.mat');
      IN_FILE_NAME = strcat(DATA_DIR, '\SYNTH_', int2str(num_y), '_', ...
                            int2str(num_x), '_', STYLE, ...
                            '_', int2str(nt), '.mat');
                 
      load(IN_FILE_NAME)
      [mean_bound1, mean_bound2, mean_gauss, mean_naive, ...
       mean_rand, mean_all, sel_K_rand, sel_K_naive, sel_K_bound1, ...
       sel_K_bound2, sel_K_gauss] = ...
          test_methods(K, L, S, y_keep, K_width, Y, num_mcmc, burn_in, ...
                       sd_run{level * s * nt});
      save(OUT_FILE_NAME, ...
           'mean_bound1', 'mean_bound2', 'mean_gauss', 'mean_naive', ...
           'mean_rand', 'mean_all', 'sel_K_rand', 'sel_K_naive', ...
           'sel_K_bound1', 'sel_K_bound2', 'sel_K_gauss', ...
           'y_keep', 'num_mcmc', 'burn_in');
    end
  end
end
