function aux_noise_std = set_aux_noise_std(Lelement_fn, prior_std, K)
%SET_AUX_NOISE_STD compute a diagonal element of S auxiliary variance matrix
%
%     aux_noise_std = set_aux_noise_std(Lelement_fn, prior_std)
%
% Inputs:
%        Lelement_fn  @fn takes an array of possible values for f_n and computes
%                         the log-likelihood, log(p(data|f_n)), of each setting.
%          prior_std  1x1 marginal prior std-dev of f_n, sqrt(K(n,n))
%
% Outputs:
%     aux_noise_std  1x1 recommended value for S(n,n)

% Iain Murray, November 2009, January 2010

% I did try using fancier quadrature. see:
%   set_aux_noise_std_quad
% for my attempt. It is is fiddly numerically (need to first identify size of a
% large likelihood value to subtract off to avoid overflow), Matlab's quadrature
% routines are either not robust, or slower than the more straightforward code
% here. Although the code here will fail on very sharply peaked likelihoods,
% a simple diagnostic is performed to notice this, but more code could be
% written to deal with it.

prior_var = prior_std*prior_std;
prior_precision = 1/prior_var;

if nargin < 3
    K = 100;
end
hh = 1/K;
persistent grid;
if length(grid) ~= K
    grid = 8*(hh/2:hh:(1-hh/2)) - 4;
end

% Numerically find variance of marginal posterior given a single observation
f = grid * prior_std;
Lpoststar = Lelement_fn(f) - 0.5*prior_precision*f.*f;
post = exp(Lpoststar - logsumexp(Lpoststar(:)));
if max(post) > 0.5
    warning(sprintf(['Posterior sharply peaked compared to grid.\n' ...
        'TODO write code here to refine numerical approximation.']));
end
post_mu = f * post(:);
post_var = (f - post_mu).^2 * post(:);

% Compute width of Gaussian likelihood that would give same posterior variance
post_precision = 1/post_var;
if post_precision <= prior_precision
    aux_noise_std = Inf;
else
    aux_noise_std = sqrt(1 / (post_precision - prior_precision));
end
