function run_mine_fixed_noise()

addpath('gpml');

experiment_setup()

setup = setup_mine();
name  = 'mine_fixed_noise';

fn = @(run) mine_run(setup, run);
success = experiment_run(name, setup.runs, fn, true);

function results = mine_run(setup, run)

UNPACK_STRUCT(setup);

counting_llh = add_call_counter(llh_fn, {});
counting_cov = add_call_counter(cov_fn, {});

tic;

[N D]     = size(X);
theta     = log(rand(D)*(max_ls-min_ls) + min_ls);
chol_cov  = chol(counting_cov(theta));
ff        = chol_cov' * randn([N 1]);
gain      = 1; 
gp_mean   = log(mean(Y));
cur_llh   = counting_llh(ff, gain, gp_mean);

ff_samples       = zeros([iterations N]);
theta_samples    = zeros([iterations D]);
gain_samples     = zeros([iterations 1]);
mean_samples     = zeros([iterations 1]);
cond_llh_samples = zeros([iterations 1]);
comp_llh_samples = zeros([iterations 1]);
num_llh_calls    = zeros([iterations+burn 1]);
num_cov_calls    = zeros([iterations+burn 1]);

for ii = (1-burn):iterations
  if mod(ii, 1) == 0
    fprintf('%03d/%03d] Iter %05d / %05d\n', run, runs, ii, iterations);
  end
  
  [theta ff aux chol_cov] = update_theta_aux_fixed(theta, ff, @(x) counting_llh(x, gain, gp_mean), ...
    counting_cov, ...
    @(theta,K) aux_noise_fn(theta, K, gain, gp_mean), ...
    theta_log_prior, slice_width);
    
  for jj = 1:ess_iterations
    [ff cur_llh] = gppu_elliptical(ff, chol_cov, @(x) counting_llh(x, gain, gp_mean));
  end
  
  [gain    cur_llh] = update_gain(gain, ff, gp_mean, cur_llh);
  [gp_mean cur_llh] = update_mean(gp_mean, ff, gain, cur_llh);

  num_llh_calls(ii+burn) = counting_llh({});
  num_cov_calls(ii+burn) = counting_cov({});
  if ii > 0
    ff_samples(ii,:)     = ff';
    theta_samples(ii,:)  = theta';
    gain_samples(ii)     = gain;
    mean_samples(ii)     = gp_mean;
    cond_llh_samples(ii) = cur_llh;
    comp_llh_samples(ii) = cur_llh - 0.5*ff'*solve_chol(chol_cov, ff) - sum(log(diag(chol_cov))) - 0.5*N*log(2*pi);
  end
end

elapsed = toc;

results.ff_samples           = ff_samples;
results.theta_samples        = theta_samples;
results.gain_samples         = gain_samples;
results.mean_samples         = mean_samples;
results.cond_llh_samples     = cond_llh_samples;
results.comp_llh_samples     = comp_llh_samples;
results.num_llh_calls        = num_llh_calls;
results.num_cov_calls        = num_cov_calls;
results.elapsed              = elapsed;
results.eff_cond_llh_samples = effective_size_rcoda(cond_llh_samples(:));
results.eff_comp_llh_samples = effective_size_rcoda(comp_llh_samples(:));

fprintf('%03d/%3d] CondLLH Eff Samp: %0.2f  CompLLH Eff Samp: %0.2f   %0.2f secs\n\n', ...
  run, runs, results.eff_cond_llh_samples, results.eff_comp_llh_samples, elapsed);
