function batched_data = make_batched(data, num_batches)
% function batched_data = make_batched(data, num_batches)
%
% Inputs:
%              data DxN Note parity! Many people use NxD, I don't (here).
%       num_batches 1x1 
%
% Outputs:
%     batched_data  cel array of data split into batches, arrays of size Dx(N/num_batches +/- 1)

% Iain Murray, August 2007


% data = [...
% 101, 201, 301, 401, 501, 601;...
% 102, 202, 302, 402, 502, 602;...
% 103, 203, 303, 403, 503, 603;...
% 104, 204, 304, 404, 504, 604;...
% 105, 205, 305, 405, 505, 605];

[dim, num_cases] = size(data);
batch_size = floor(num_cases/num_batches);
batch_sizes = repmat(batch_size, num_batches, 1);
remainder = num_cases - batch_size*num_batches;
batch_sizes(1:remainder) = batch_sizes(1:remainder) + 1;

batched_data = mat2cell(data, dim, batch_sizes);
